<?php

if (!defined('DS')) {
    define('DS', DIRECTORY_SEPARATOR);
}

if (!class_exists('DATABASE_CONFIG')) {
    require_once __DIR__ . DS . 'Config' . DS . 'database.php';
}

$db_config = new DATABASE_CONFIG();

$db = $db_config->default;


switch ($db[ 'datasource' ]) {
    case "Database/Sqlite":
        $adapter = 'sqlite';
        break;
    case "Database/Postgres":
        $adapter = 'pgsql';
        break;
    case "Database/Sqlserver":
        $adapter = 'sqlsrv';
        break;
    default:
        $adapter = 'mysql';
}

return array(
    "paths"        => array(
        "migrations" => __DIR__ . DS . "phinx" . DS . "migrations",
        "seeds"      => __DIR__ . DS . "phinx" . DS . "seeds"
    ),
    "environments" => array(
        "default_migration_table" => "phinxlog",
        "default_database"        => "default",
        "default"                 => array(
            "adapter"      => $adapter,
            "host"         => $db[ 'host' ],
            "name"         => $db[ 'database' ],
            "user"         => $db[ 'login' ],
            "pass"         => $db[ 'password' ],
            "table_prefix" => $db[ 'prefix' ],
            "charset"      => $db[ 'utf8' ],
            "port"         => $db[ 'port' ]
        )
    )
);
